---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-Resume Data Cache

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/resume-data-cache/resume-data-cache.ts` - Resume Data Cache実装
- E-02: `packages/next/src/server/resume-data-cache/cache-store.ts` - キャッシュストア実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RenderResumeDataCacheがイミュータブル（setなし） | E-01 (16-42行目) | ○ |
| C-02 | PrerenderResumeDataCacheがミュータブル（get/set可） | E-01 (48-77行目) | ○ |
| C-03 | Edge Runtimeでの呼び出し禁止 | E-01 (106-109行目, 187-189行目) | ○ |
| C-04 | 空キャッシュ時に'null'文字列を返す | E-01 (111-113行目) | ○ |
| C-05 | zlib.deflateSyncで圧縮しBase64エンコード | E-01 (137-139行目) | ○ |
| C-06 | maxDecompressedSizeはmaxPostponedStateSizeBytes * 5 | E-01 (216-218行目) | ○ |
| C-07 | デフォルト最大展開サイズは500MB | E-01 (218行目) | ○ |
| C-08 | ERR_BUFFER_TOO_LARGEのハンドリング | E-01 (228-234行目) | ○ |
| C-09 | createPrerenderResumeDataCacheが空のMap x 4を返す | E-01 (150-157行目) | ○ |
| C-10 | createRenderResumeDataCacheの3つのオーバーロード | E-01 (170-180行目) | ○ |
| C-11 | 文字列以外のキャッシュは直接返す（型変更のみ） | E-01 (192-195行目) | ○ |
| C-12 | 'null'文字列の場合は空のMapを返す | E-01 (198-204行目) | ○ |
| C-13 | CacheStore型がMapのサブセット | E-02 (12-15行目) | ○ |
| C-14 | parseUseCacheCacheStoreがReadableStreamを復元 | E-02 (56-88行目) | ○ |
| C-15 | serializeUseCacheCacheStoreがtee()でストリーム分岐 | E-02 (112行目) | ○ |
| C-16 | キャッシュエントリの書き込み失敗は.catch(() => null)で無視 | E-02 (137-141行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全コードがresume-data-cache/ディレクトリ内に収まっており、網羅的に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Resume Data CacheがPPRレンダリングパイプラインでどのように利用されるかを確認
- [ ] zlib圧縮/展開のパフォーマンス影響を確認
- [ ] encryptedBoundArgsの暗号化/復号化フローの詳細を確認
